#charset "us-ascii"

/* 
 *   Include the main header for the standard TADS 3 adventure library.
 *   
 *   Also include the US English definitions, since this game is written
 *   in English.  
 */
#include <adv3.h>
#include <en_us.h>

versionInfo: GameID
    IFID = '2f7c1b0d-c14d-42b7-5751-5d5adf7d075d'
    name = 'Maze Generator'
    byline = 'by Jeffrey W. Bowyer'
    htmlByline = 'by <a href="mailto:JeffBowyer@seznam.cz">
                  Jeffrey W. Bowyer</a>'
    version = '1'
    authorEmail = 'Jeffrey W. Bowyer <JeffBowyer@seznam.cz>'
    desc = 'Prototype code for processing a virtual maze.'
    htmlDesc = 'Prototype code for processing a virtual maze.'
;

/* 
 *   A room with a virtual maze
 */
AnyRoom: Room 'Maze Crawl'
    "\bUse the commands 'mwest', 'meast', 'mnorth', and 'msouth' to crawl through
    the maze.\b
    \b
    Use the command 'mvisited' to see a map that includes only those areas of the maze
    you have already explored (which may or may not include the maze's exit).\b
    \b    
    Use the command 'mreveal' to see a map of the entire maze, including your current
    position and the location of the maze's exit.\b
    \b
    Now, find the exit!\b\b"   

;

+ myMaze: Maze
      mazeGrid = new Vector(100,[[9,5,5,5,1,3,13,1,5,7],
[10,13,3,9,6,12,3,12,1,3],
[12,3,10,12,3,11,12,3,14,10],
[11,12,4,3,10,8,3,12,3,10],
[12,5,5,6,10,10,12,3,12,2],
[9,5,5,5,6,10,11,8,7,10],
[10,9,5,5,5,4,6,8,3,10],
[10,12,5,5,3,9,7,14,10,10],
[10,13,5,5,6,12,3,9,6,10],
[12,5,5,5,5,5,6,12,5,6]])

    randomStartFinish = true
;  
    
/*
 *   Define the player character
 */
me: Actor
    /* the initial location is the entryway */
    location = AnyRoom
;

/*
 */
gameMain: GameMainDef
    /* the initial player character is 'me' */
    initialPlayerChar = me

    /* 
     *   Show our introductory message.  This is displayed just before the
     *   game starts.  Most games will want to show a prologue here,
     *   setting up the situation for the player, and show the title of the
     *   game.  
     */
    showIntro()
    {
        "Welcome to the Maze!\b";
    }

    /* 
     *   Show the "goodbye" message.  This is displayed on our way out,
     *   after the user quits the game.  You don't have to display anything
     *   here, but many games display something here to acknowledge that
     *   the player is ending the session.  
     */
    showGoodbye()
    {
        "<.p>Thanks for playing!\b";
    }
;
